#!/bin/sh
#
# This script checks for running apps that need to be shutdown before proceeding.
# APPS_PLIST is the list of apps to check for
#

APPS_PLIST=$1

if [ $# -lt 1 ] ; then
	echo "usage: $0 <path to application plist>"
	exit 1
fi

SHUTDOWNLISTPATH="${APPS_PLIST}"
if [ ! -r "${SHUTDOWNLISTPATH}.plist" ] ; then
	echo "${SHUTDOWNLISTPATH}.plist not found."
	exit 1
fi

DEFAULTS=/usr/bin/defaults

INDEX=0
APPSEARCHSTRING=`defaults read "${SHUTDOWNLISTPATH}" "$INDEX" `

while [ -n "${APPSEARCHSTRING}" ]
do
	echo "Checking if \"${APPSEARCHSTRING}\" is running ..."
	/bin/ps awwxocommand | /usr/bin/grep -v "grep " | /usr/bin/egrep "${APPSEARCHSTRING}" > /dev/null
	if [ $? -eq 0 ] ; then
		if [ -n "${COMMAND_LINE_INSTALL}" -a "${COMMAND_LINE_INSTALL}" != 0 ] ; then
			# in silent install print out the message to the terminal.
			echo
			echo "Some applications must be closed before your new software can be installed."
			echo "Please close these applications and then restart the installer."
			echo
		fi

		# to break out of the loop
		exit 1	
	fi
	((INDEX=INDEX+1))	
	APPSEARCHSTRING=`defaults read "${SHUTDOWNLISTPATH}" "$INDEX" 2>/dev/null `
done

echo "No specified applications are currently running."
exit 0
